/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.snmp.SnmpGauge;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpString;
import com.sun.management.snmp.SnmpTimeticks;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibEntry;
import com.sun.management.snmp.agent.SnmpMibNode;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpStandardMetaServer;
import com.sun.management.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import org.opends.server.snmp.DsIntEntryMBean;

public class DsIntEntryMeta
extends SnmpMibEntry
implements Serializable,
SnmpStandardMetaServer {
    protected DsIntEntryMBean node;
    protected SnmpStandardObjectServer objectserver = null;

    public DsIntEntryMeta(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        this.objectserver = objserv;
        this.varList = new int[8];
        this.varList[0] = 9;
        this.varList[1] = 8;
        this.varList[2] = 7;
        this.varList[3] = 6;
        this.varList[4] = 5;
        this.varList[5] = 4;
        this.varList[6] = 3;
        this.varList[7] = 2;
        SnmpMibNode.sort((int[])this.varList);
    }

    public SnmpValue get(long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 9: {
                return new SnmpString(this.node.getDsIntEntURL());
            }
            case 8: {
                return new SnmpGauge(this.node.getDsIntEntSuccesses());
            }
            case 7: {
                return new SnmpGauge(this.node.getDsIntEntFailures());
            }
            case 6: {
                return new SnmpGauge(this.node.getDsIntEntFailuresSinceLastSuccess());
            }
            case 5: {
                return new SnmpTimeticks(this.node.getDsIntEntTimeOfLastSuccess());
            }
            case 4: {
                return new SnmpTimeticks(this.node.getDsIntEntTimeOfLastAttempt());
            }
            case 3: {
                return new SnmpTimeticks(this.node.getDsIntEntTimeOfCreation());
            }
            case 2: {
                return new SnmpString(this.node.getDsIntEntDirectoryName());
            }
            case 1: {
                throw new SnmpStatusException(224);
            }
        }
        throw new SnmpStatusException(225);
    }

    public SnmpValue set(SnmpValue x, long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 9: {
                throw new SnmpStatusException(17);
            }
            case 8: {
                throw new SnmpStatusException(17);
            }
            case 7: {
                throw new SnmpStatusException(17);
            }
            case 6: {
                throw new SnmpStatusException(17);
            }
            case 5: {
                throw new SnmpStatusException(17);
            }
            case 4: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
        }
        throw new SnmpStatusException(17);
    }

    public void check(SnmpValue x, long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 9: {
                throw new SnmpStatusException(17);
            }
            case 8: {
                throw new SnmpStatusException(17);
            }
            case 7: {
                throw new SnmpStatusException(17);
            }
            case 6: {
                throw new SnmpStatusException(17);
            }
            case 5: {
                throw new SnmpStatusException(17);
            }
            case 4: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
        }
        throw new SnmpStatusException(17);
    }

    protected void setInstance(DsIntEntryMBean var) {
        this.node = var;
    }

    public void get(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.get((SnmpStandardMetaServer)this, req, depth);
    }

    public void set(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.set((SnmpStandardMetaServer)this, req, depth);
    }

    public void check(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.check((SnmpStandardMetaServer)this, req, depth);
    }

    public boolean isVariable(long arc) {
        switch ((int)arc) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean isReadable(long arc) {
        switch ((int)arc) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean skipVariable(long var, Object data, int pduVersion) {
        switch ((int)var) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public String getAttributeName(long id) throws SnmpStatusException {
        switch ((int)id) {
            case 9: {
                return "DsIntEntURL";
            }
            case 8: {
                return "DsIntEntSuccesses";
            }
            case 7: {
                return "DsIntEntFailures";
            }
            case 6: {
                return "DsIntEntFailuresSinceLastSuccess";
            }
            case 5: {
                return "DsIntEntTimeOfLastSuccess";
            }
            case 4: {
                return "DsIntEntTimeOfLastAttempt";
            }
            case 3: {
                return "DsIntEntTimeOfCreation";
            }
            case 2: {
                return "DsIntEntDirectoryName";
            }
            case 1: {
                return "DsIntEntIndex";
            }
        }
        throw new SnmpStatusException(225);
    }
}

